<?php

// Init this
$HTML = '';

// #############################################################################
if ($_REQUEST['action'] == 'download' OR empty($_REQUEST['action']))
{
	if ($vbulletin->userinfo['posts'] < $vbulletin->options['dbtech_downloads_min_posts'] /*DBTECH_PRO_START*/AND !VBDOWNLOADS::$permissions['bypassminposts']/*DBTECH_PRO_END*/)
	{
		// Lacking necessary post count
		standard_error(construct_phrase($vbphrase['dbtech_downloads_you_need_x_posts_to_download'], $vbulletin->options['dbtech_downloads_min_posts']));
	}

	$vbulletin->input->clean_gpc('r', 'fileid', TYPE_UINT);

	$file = VBDOWNLOADS::$db->fetchRow('
		SELECT download.*, file.*
		FROM $dbtech_downloads_file AS file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE fileid = ?
	', array(
		$vbulletin->GPC['fileid'],
	));

	if ($file['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	$file['private'] = @unserialize($file['private']);
	if (
		is_array($file['private']) AND
		count($file['private']) AND
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		!in_array($vbulletin->userinfo['userid'], $file['private']) AND 
		$file['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private screenshot and we're not authorised to view it
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	if (in_array($file['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$file['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $file['categoryid']));
	}

	// Update cookie if we have one
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'downloadpass_' . $file['downloadid'] => TYPE_STR,
	));

	if (
		$file['password'] AND 
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$file['userid'] != $vbulletin->userinfo['userid'] AND 
		md5($file['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $file['downloadid']]
	)
	{
		// We're missing password
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	/*DBTECH_PRO_START*/
	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_downloads_today'] >= $vbulletin->userinfo['permissions']['dbtech_downloads_downloadsperday'] AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We hit max number of downloaded files
		standard_error(fetch_error('dbtech_downloads_downloads_quota_reached'));
	}
	
	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_download_size_today'] >= $vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We hit max downloaded file size
		standard_error(fetch_error('dbtech_downloads_size_quota_reached'));
	}
	
	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_download_size_today'] > ($vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] + $file['filesize']) AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We would have gone above quota if we downloaded
		standard_error(fetch_error('dbtech_downloads_size_quota_would_be_reached'));
	}

	// Ensure filepath is set
	if ($file['filepath'])
	{
		$file['filepath'] = $file['filepath'] . '/';
	}
	else
	{
		$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
		$file['filename'] = $file['fileid'] . '-' . $file['filename'];
	}

	if (!file_exists($file['filepath'] . $file['filename']))
	{
		// File missing
		standard_error(fetch_error('dbtech_downloads_file_missing'));
	}

	// Grab our permissions
	$permissions = VBDOWNLOADS::fetchPermissions($file, $category);

	if (!$permissions['candownload'])
	{
		// We can't upload
		print_no_permission();
	}

	if ($vbulletin->userinfo['permissions']['dbtech_downloads_delay'])
	{
		// Fetch delay info
		$delayInfo = VBDOWNLOADS::$db->fetchRow('
			SELECT * FROM $dbtech_downloads_delay
			WHERE userid = ? 
				AND fileid = ?
		', array(
			$vbulletin->userinfo['userid'],
			$file['fileid']
		));
		if (!$delayInfo)
		{
			// Create array of delay info
			$delayInfo = array(
				'userid' 	=> $vbulletin->userinfo['userid'],
				'fileid' 	=> $file['fileid'],
				'dateline' 	=> TIMENOW + intval($vbulletin->userinfo['permissions']['dbtech_downloads_delay'])
			);

			// Insert delay info
			VBDOWNLOADS::$db->insert('dbtech_downloads_delay', $delayInfo, array(), false);
		}
		else if ($delayInfo['dateline'] <= (TIMENOW + 1))
		{
			// Remove delay info
			VBDOWNLOADS::$db->delete('dbtech_downloads_delay', array(
				$vbulletin->userinfo['userid'],
				$file['fileid']
			), 'WHERE userid = ? AND fileid = ?');
		}

		if ($delayInfo['dateline'] > (TIMENOW + 1))
		{
			// Display the correct delay
			$delayInfo['remaining'] = $delayInfo['dateline'] - TIMENOW;

			// We need the nag screen
			$templater = vB_Template::create('dbtech_downloads_delay');
				$templater->register('delay', 			$delayInfo);
				$templater->register('versionnumber', 	VBDOWNLOADS::$versionnumber);
			$HTML = $templater->render();
		}
	}
	/*DBTECH_PRO_END*/

	if (!$HTML)
	{
		// Finally grab file info
		$fileinfo = pathinfo($file['filename']);

		$fileExtension = array();
		foreach (VBDOWNLOADS::$cache['extension'] as $extension)
		{
			if ($extension['extension'] == $fileinfo['extension'])
			{
				// This is the extension we are looking for
				$fileExtension = $extension;
				break;
			}
		}

		if (empty($fileExtension))
		{
			standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_extension'], $fileinfo['extension']));
		}

		// Ensure filepath is set
		if ($file['filepath'])
		{
			$file['filepath'] = $file['filepath'] . '/';
		}
		else
		{
			$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
			$file['filename'] = $file['fileid'] . '-' . $file['filename'];
		}

		// Update the download
		$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
			$dm->set_existing($file);
			$dm->set('totaldownloads', 'totaldownloads + 1', false);
		$dm->save();

		// Update the file
		$dm =& VBDOWNLOADS::initDataManager('File', $vbulletin, ERRTYPE_SILENT);
			$dm->set_existing($file);
			$dm->set('downloads', 'downloads + 1', false);
		$dm->save();

		// Increment downloads per day and download size today
		VBDOWNLOADS::$db->query('
			UPDATE $user
			SET 
				dbtech_downloads_downloads_today = dbtech_downloads_downloads_today + 1,
				dbtech_downloads_download_size_today = dbtech_downloads_download_size_today + ?
			WHERE userid = ?
		', array(
			$file['downloadid'],
			$file['filesize']
		));

		// Add to download log
		VBDOWNLOADS::$db->insert('dbtech_downloads_downloadlog', array(
			'userid' 		=> $vbulletin->userinfo['userid'],
			'fileid' 		=> $file['fileid'],
			'downloadid' 	=> $file['downloadid'],
			'ipaddress' 	=> IPADDRESS,
			'dateline' 		=> TIMENOW,
			'filesize' 		=> $file['filesize']
		));

		// Now finally download the file
		download_file($file['filepath'] . $file['filename'], str_replace($file['fileid'] . '-', '', $file['filename']), $fileExtension['mime']);
	}
}

/*DBTECH_PRO_START*/
// #############################################################################
if ($_REQUEST['action'] == 'downloadzip')
{
	if ($vbulletin->userinfo['posts'] < $vbulletin->options['dbtech_downloads_min_posts'] /*DBTECH_PRO_START*/AND !VBDOWNLOADS::$permissions['bypassminposts']/*DBTECH_PRO_END*/)
	{
		// Lacking necessary post count
		standard_error(construct_phrase($vbphrase['dbtech_downloads_you_need_x_posts_to_download'], $vbulletin->options['dbtech_downloads_min_posts']));
	}

	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);

	$download = VBDOWNLOADS::$db->fetchRow('
		SELECT *
		FROM $dbtech_downloads_download
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	$download['private'] = @unserialize($download['private']);
	if (
		is_array($download['private']) AND
		count($download['private']) AND
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		!in_array($vbulletin->userinfo['userid'], $download['private']) AND 
		$download['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private screenshot and we're not authorised to view it
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	if (in_array($download['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	// Update cookie if we have one
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'downloadpass_' . $download['downloadid'] => TYPE_STR,
	));

	if (
		$download['password'] AND 
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$download['userid'] != $vbulletin->userinfo['userid'] AND 
		md5($download['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $download['downloadid']]
	)
	{
		// We're missing password
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	$fileList = VBDOWNLOADS::$db->fetchAll('
		SELECT *
		FROM $dbtech_downloads_file
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	$totalFileSize = 0;
	foreach ($fileList as $file)
	{
		// Create total file size for the zip
		$totalFileSize += $file['filesize'];
	}

	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_downloads_today'] >= $vbulletin->userinfo['permissions']['dbtech_downloads_downloadsperday'] AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We hit max number of downloaded files
		standard_error(fetch_error('dbtech_downloads_downloads_quota_reached'));
	}
	
	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_downloads_today'] > ($vbulletin->userinfo['permissions']['dbtech_downloads_downloadsperday'] + $download['numfiles']) AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We hit max number of downloaded files
		standard_error(fetch_error('dbtech_downloads_downloads_quota_would_be_reached'));
	}
	
	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_download_size_today'] >= $vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We hit max downloaded file size
		standard_error(fetch_error('dbtech_downloads_size_quota_reached'));
	}
	
	if (
		$vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] AND 
		$vbulletin->userinfo['dbtech_downloads_download_size_today'] > ($vbulletin->userinfo['permissions']['dbtech_downloads_downloadsizeperday'] + $file['filesize']) AND
		!VBDOWNLOADS::$permissions['ismanager']
	)
	{
		// We would have gone above quota if we downloaded
		standard_error(fetch_error('dbtech_downloads_size_quota_would_be_reached'));
	}

	if ($vbulletin->userinfo['permissions']['dbtech_downloads_delay'])
	{
		// Fetch delay info
		$delayInfo = VBDOWNLOADS::$db->fetchRow('
			SELECT * FROM $dbtech_downloads_delay
			WHERE userid = ? 
				AND fileid = ?
		', array(
			$vbulletin->userinfo['userid'],
			0
		));
		if (!$delayInfo)
		{
			// Create array of delay info
			$delayInfo = array(
				'userid' 	=> $vbulletin->userinfo['userid'],
				'fileid' 	=> 0,
				'dateline' 	=> TIMENOW + intval($vbulletin->userinfo['permissions']['dbtech_downloads_delay'])
			);

			// Insert delay info
			VBDOWNLOADS::$db->insert('dbtech_downloads_delay', $delayInfo);
		}
		else if ($delayInfo['dateline'] <= (TIMENOW + 1))
		{
			// Remove delay info
			VBDOWNLOADS::$db->delete('dbtech_downloads_delay', array(
				$vbulletin->userinfo['userid'],
				0
			), 'WHERE userid = ? AND fileid = ?');
		}

		if ($delayInfo['dateline'] > (TIMENOW + 1))
		{
			// Display the correct delay
			$delayInfo['remaining'] = $delayInfo['dateline'] - TIMENOW;

			// We need the nag screen
			$templater = vB_Template::create('dbtech_downloads_delay');
				$templater->register('delay', 			$delayInfo);
				$templater->register('versionnumber', 	VBDOWNLOADS::$versionnumber);
			$HTML = $templater->render();
		}
	}

	if (!$HTML)
	{
		// Store important variables
		$filename 	= $vbulletin->options['dbtech_downloads_zip_prefix'];
		$zipName 	= $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/' . TIMENOW . '.zip';
		
		// Generate zip
		$zip = new ZipArchive();
		if ($zip->open($zipName, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE) !== true)
		{
			// Should never happen
			die('Cannot create zip');
		}

		foreach ($fileList as $file)
		{
			// Ensure filepath is set
			if ($file['filepath'])
			{
				$file['filepath'] = $file['filepath'] . '/';
			}
			else
			{
				$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
				$file['filename'] = $file['fileid'] . '-' . $file['filename'];
			}

			if (!file_exists($file['filepath'] . $file['filename']))
			{
				// File didn't exist
				continue;
			}

			// Add the file to the zip
			$zip->addFile($file['filepath'] . $file['filename'], str_replace($file['fileid'] . '-', '', $file['filename']));

			// Update the download
			$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
				$dm->set_existing($download);
				$dm->set('totaldownloads', 'totaldownloads + 1', false);
			$dm->save();

			// Update the file
			$dm =& VBDOWNLOADS::initDataManager('File', $vbulletin, ERRTYPE_SILENT);
				$dm->set_existing($file);
				$dm->set('downloads', 'downloads + 1', false);
			$dm->save();

			// Increment downloads per day and download size today
			VBDOWNLOADS::$db->query('
				UPDATE $user
				SET 
					dbtech_downloads_downloads_today = dbtech_downloads_downloads_today + 1,
					dbtech_downloads_download_size_today = dbtech_downloads_download_size_today + ?
				WHERE userid = ?
			', array(
				$file['downloadid'],
				$file['filesize']
			));

			// Add to download log
			VBDOWNLOADS::$db->insert('dbtech_downloads_downloadlog', array(
				'userid' 		=> $vbulletin->userinfo['userid'],
				'fileid' 		=> $file['fileid'],
				'downloadid' 	=> $file['downloadid'],
				'ipaddress' 	=> IPADDRESS,
				'dateline' 		=> TIMENOW,
				'filesize' 		=> $file['filesize']
			));
		}
		$zip->close();

		// Now finally download the file
		download_file($zipName, $vbulletin->options['dbtech_downloads_zip_prefix'] . str_replace(array('\\', '/', '*', '?', '"', '<', '>', '|'), '_', $download['title']) . '.zip', 'application/zip', true);
	}
}
/*DBTECH_PRO_END*/

// #############################################################################
if ($_REQUEST['action'] == 'screenshot')
{
	$vbulletin->input->clean_gpc('r', 'screenshotid', TYPE_UINT);

	$file = VBDOWNLOADS::$db->fetchRow('
		SELECT download.*, file.*
		FROM $dbtech_downloads_file AS file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE file.fileid = ?
			AND file.image = ?
			AND file.screenshot = ?
	', array(
		$vbulletin->GPC['screenshotid'],
		1,
		1
	));

	// Default image info
	$imageinfo = array(
		'extension' => 'png',
		'filename' => 'noimage',
		'path' => 'dbtech/downloads/images',
	);

	do
	{
		if (!$file)
		{
			// Couldn't find it
			break;
		}

		if ($file['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
		{
			// File is under moderation
			break;
		}

		$file['private'] = @unserialize($file['private']);
		if (
			is_array($file['private']) AND
			count($file['private']) AND
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			!in_array($vbulletin->userinfo['userid'], $file['private']) AND 
			$file['userid'] != $vbulletin->userinfo['userid']
		)
		{
			// Private screenshot and we're not authorised to view it
			break;
		}

		if (in_array($file['categoryid'], $_excludeCategories))
		{
			// Can't view category
			break;
		}

		if (!$category = VBDOWNLOADS::$cache['category'][$file['categoryid']])
		{
			// Invalid category
			break;
		}

		// Update cookie if we have one
		$vbulletin->input->clean_array_gpc('c', array(
			COOKIE_PREFIX . 'downloadpass_' . $file['downloadid'] => TYPE_STR,
		));

		if (
			$file['password'] AND 
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			$file['userid'] != $vbulletin->userinfo['userid'] AND 
			md5($file['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $file['downloadid']]
		)
		{
			// We're missing password
			break;
		}

		// Ensure filepath is set
		if ($file['filepath'])
		{
			$file['filepath'] = $file['filepath'] . '/';
		}
		else
		{
			$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
			$file['filename'] = $file['fileid'] . '-' . $file['filename'];
		}

		// We found the screenshot
		$imageinfo = pathinfo($file['filename']);
		$imageinfo['path'] = $file['filepath'];
	}
	while (false);
}

// #############################################################################
if ($_REQUEST['action'] == 'thumbnail')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);

	$fileList = VBDOWNLOADS::$db->fetchAll('
		SELECT download.*, file.*
		FROM $dbtech_downloads_file AS file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE file.downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	// Default image info
	$imageinfo = array(
		'extension' => 'png',
		'filename' => 'noimage',
		'path' => 'dbtech/downloads/images',
	);

	do
	{
		// First do permission checks
		foreach ($fileList as $file)
		{
			if (!$file)
			{
				// Couldn't find it
				break 2;
			}

			if ($file['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
			{
				// File is under moderation
				break 2;
			}

			$file['private'] = @unserialize($file['private']);
			if (
				is_array($file['private']) AND
				count($file['private']) AND
				!VBDOWNLOADS::$permissions['ismanager'] AND 
				!in_array($vbulletin->userinfo['userid'], $file['private']) AND 
				$file['userid'] != $vbulletin->userinfo['userid']
			)
			{
				// Private screenshot and we're not authorised to view it
				break 2;
			}

			if (in_array($file['categoryid'], $_excludeCategories))
			{
				// Can't view category
				break 2;
			}

			if (!$category = VBDOWNLOADS::$cache['category'][$file['categoryid']])
			{
				// Invalid category
				break 2;
			}

			// Update cookie if we have one
			$vbulletin->input->clean_array_gpc('c', array(
				COOKIE_PREFIX . 'downloadpass_' . $file['downloadid'] => TYPE_STR,
			));

			if (
				$file['password'] AND 
				!VBDOWNLOADS::$permissions['ismanager'] AND 
				$file['userid'] != $vbulletin->userinfo['userid'] AND 
				md5($file['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $file['downloadid']]
			)
			{
				// We're missing password
				break 2;
			}
		}

		// First check for thumbnail		
		foreach ($fileList as $file)
		{
			// Ensure filepath is set
			if ($file['filepath'])
			{
				$file['filepath'] = $file['filepath'] . '/';
			}
			else
			{
				$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
				$file['filename'] = $file['fileid'] . '-' . $file['filename'];
			}

			if ($file['image'] AND $file['thumbnail'])
			{				
				// Lucky
				$imageinfo = pathinfo($file['filename']);
				$imageinfo['path'] = $file['filepath'];
				break 2;
			}
		}

		// Then check for screenshot		
		foreach ($fileList as $file)
		{
			// Ensure filepath is set
			if ($file['filepath'])
			{
				$file['filepath'] = $file['filepath'] . '/';
			}
			else
			{
				$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
				$file['filename'] = $file['fileid'] . '-' . $file['filename'];
			}

			if ($file['image'] AND $file['screenshot'])
			{				
				// Lucky
				$imageinfo = pathinfo($file['filename']);
				$imageinfo['path'] = $file['filepath'];
				break 2;
			}
		}

		// Then check for image
		foreach ($fileList as $file)
		{
			// Ensure filepath is set
			if ($file['filepath'])
			{
				$file['filepath'] = $file['filepath'] . '/';
			}
			else
			{
				$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
				$file['filename'] = $file['fileid'] . '-' . $file['filename'];
			}

			if ($file['image'] AND !$file['screenshot'])
			{
				// Lucky
				$imageinfo = pathinfo($file['filename']);
				$imageinfo['path'] = $file['filepath'];
				break 2;
			}
		}
	}
	while (false);

	if ($imageinfo['path'] != 'dbtech/downloads/images')
	{
		if (!file_exists($imageinfo['path'] . '/thumb-' . $imageinfo['filename'] . '.' . $imageinfo['extension']))
		{
			switch ($imageinfo['extension'])
			{
				case 'jpg':
				case 'jpeg':
					/* read the source image */
					$src = imagecreatefromjpeg($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
					break;

				case 'png':
					/* read the source image */
					$src = imagecreatefrompng($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
					break;

				case 'gif':
					/* read the source image */
					$src = imagecreatefromgif($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
					break;

				default:
					header('Content-Length: ' . filesize('clear.gif'));
					header('Content-type: image/gif');
					echo readfile('clear.gif');
					die();

					break;
			}	
			
			// Determine source image width / height
			$width = imagesx($src);
			$height = imagesy($src);
			
			// Create the canvas
			$canvas = imagecreatetruecolor(100, 100);
			
			// copy source image at a resized size
			imagecopyresampled($canvas, $src, 0, 0, 0, 0, 100, 100, $width, $height);
			
			switch ($imageinfo['extension'])
			{
				case 'jpg':
				case 'jpeg':
					// create the physical thumbnail image to its destination
					imagejpeg($canvas, $imageinfo['path'] . '/thumb-' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
					break;

				case 'png':
					// create the physical thumbnail image to its destination
					imagepng($canvas, $imageinfo['path'] . '/thumb-' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
					break;

				case 'gif':
					// create the physical thumbnail image to its destination
					imagegif($canvas, $imageinfo['path'] . '/thumb-' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
					break;

				default:
					header('Content-Length: ' . filesize('clear.gif'));
					header('Content-type: image/gif');
					echo readfile('clear.gif');
					die();

					break;
			}
		}

		// Set the new filename since we now have a shiny thumbnail
		$imageinfo['filename'] = 'thumb-' . $imageinfo['filename'];		
	}

}

// #############################################################################
if (in_array($_REQUEST['action'], array('screenshot', 'thumbnail')))
{
	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}

	exec_shut_down();
	$vbulletin->db->close();

	if (!isset($imageinfo) OR !is_array($imageinfo))
	{
		// Unknown error, die silently
		die();
	}

	if (!$_REQUEST['debug'])
	{
	header('Pragma:'); // VBIV-8269 
	header('Cache-control: max-age=31536000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (time() + 31536000)) . ' GMT');
	header('Content-disposition: inline; filename=' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
	header('Content-transfer-encoding: binary');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
	switch ($imageinfo['extension'])
	{
		case 'jpg':
		case 'jpeg':
			header('Content-type: image/jpeg');
			break;

		case 'png':
			header('Content-type: image/png');
			break;

		case 'gif':
			header('Content-type: image/gif');
			break;

		default:
			header('Content-Length: ' . filesize('clear.gif'));
			header('Content-type: image/gif');
			echo readfile('clear.gif');
			die();

			break;
	}
	header('Content-Length: ' . filesize($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']));
	}
	echo readfile($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']);

	die();
}

// #############################################################################
if ($_REQUEST['action'] == 'handler')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);

	if (substr($vbulletin->options['dbtech_downloads_path_to_downloads'], 0, 2) == './')
	{
		// Prepare this
		$vbulletin->options['dbtech_downloads_path_to_downloads'] = str_replace('./', DIR . '/', $vbulletin->options['dbtech_downloads_path_to_downloads']);
	}

	$extensions = array();
	foreach (VBDOWNLOADS::$cache['extension'] as $extension)
	{
		// Add to allowed extensions
		$extensions[] = $extension['extension'];
	}

	require_once(DIR . '/dbtech/downloads/includes/class_uploadhandler.php');
	$upload_handler = new UploadHandler(array(
		'script_url' => $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=file&action=handler&downloadid=' . $vbulletin->GPC['downloadid'],
		'upload_dir' => $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/',
		'mkdir_mode' => 0755, // Replace this with a setting
		'accept_file_types' => '/.(' . implode('|', $extensions) . ')$/i',	// Defines which files (based on their names) are accepted for upload
		'max_number_of_files' => $vbulletin->options['dbtech_downloads_max_downloads'],
	));

	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}

	exec_shut_down();
	$vbulletin->db->close();

	die();
}

// #############################################################################
if ($_REQUEST['action'] == 'mirror')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'mirrorid', TYPE_UINT);

	if ($vbulletin->userinfo['posts'] < $vbulletin->options['dbtech_downloads_min_posts'] /*DBTECH_PRO_START*/AND !VBDOWNLOADS::$permissions['bypassminposts']/*DBTECH_PRO_END*/)
	{
		// Lacking necessary post count
		standard_error(construct_phrase($vbphrase['dbtech_downloads_you_need_x_posts_to_download'], $vbulletin->options['dbtech_downloads_min_posts']));
	}

	$download = VBDOWNLOADS::$db->fetchRow('
		SELECT *
		FROM $dbtech_downloads_download
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	$download['private'] = @unserialize($download['private']);
	if (
		is_array($download['private']) AND
		count($download['private']) AND
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		!in_array($vbulletin->userinfo['userid'], $download['private']) AND 
		$download['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private screenshot and we're not authorised to view it
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	if (in_array($download['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	// Update cookie if we have one
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'downloadpass_' . $download['downloadid'] => TYPE_STR,
	));

	if (
		$download['password'] AND 
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$download['userid'] != $vbulletin->userinfo['userid'] AND 
		md5($download['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $download['downloadid']]
	)
	{
		// We're missing password
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	// Ensure we can't have 0
	$vbulletin->GPC['mirrorid'] = $vbulletin->GPC['mirrorid'] ? $vbulletin->GPC['mirrorid'] : 1;

	$i = 1;
	$mirrorList = @unserialize($download['mirrors']);
	$mirrorList = is_array($mirrorList) ? $mirrorList : array();

	if (!isset($mirrorList[$vbulletin->GPC['mirrorid'] - 1]))
	{
		// @TODO: REAL ERROR
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	// Shorthand
	$mirror =& $mirrorList[$vbulletin->GPC['mirrorid'] - 1];

	if (!is_array($mirrorList[$vbulletin->GPC['mirrorid'] - 1]))
	{
		// Convert to new format
		foreach ($mirrorList as &$file)
		{
			if (!is_array($file))
			{
				$file = array(
					'link' => $file,
					'hits' => 0,
				);
			}
		}
	}

	// Increment hits counter
	$mirror['hits']++;

	// Update the download
	$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($download);
		$dm->set('mirrors', $mirrorList);
	$dm->save();

	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}

	exec_shut_down();
	$vbulletin->db->close();

	// Redirect to the actual mirror url
	header('Location: ' . $mirror['link']);
	die();
}

// #############################################################################
if ($_REQUEST['action'] == 'keepalive')
{
	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}

	exec_shut_down();
	$vbulletin->db->close();

	echo "success";
	die();
}

function download_file($filepath, $filename, $filetype = 'application/octet-stream', $unlink = false)
{
	if (!isset($isIE))
	{
		static $isIE;
		$isIE = iif(is_browser('ie') OR is_browser('opera'), true, false);
	}

	if ($isIE AND $filetype == 'application/octet-stream')
	{
		$filetype = 'application/octetstream';
	}

	global $vbulletin;
	if (intval($vbulletin->versionnumber) == 3)
	{
		if (preg_match('~&#([0-9]+);~', $filename))
		{
			if (function_exists('iconv'))
			{
				$filename = @iconv($stylevar['charset'], 'UTF-8//IGNORE', $filename);
			}

			$filename = preg_replace(
				'~&#([0-9]+);~e',
				"convert_int_to_utf8('\\1')",
				$filename
			);
			$filename_charset = 'utf-8';
		}
		else
		{
			$filename_charset = $stylevar['charset'];
		}
	}
	else
	{
		if (preg_match('~&#([0-9]+);~', $filename))
		{
			if (function_exists('iconv'))
			{
				$filename = @iconv(vB_Template_Runtime::fetchStyleVar('charset'), 'UTF-8//IGNORE', $filename);
			}

			$filename = preg_replace_callback(
				'~&#([0-9]+);~',
				'convert_int_to_utf8_callback',
				$filename
			);
			$filename_charset = 'utf-8';
		}
		else
		{
			$filename_charset = vB_Template_Runtime::fetchStyleVar('charset');
		}
	}
	$filename = preg_replace('#[\r\n]#', '', $filename);

	// Opera and IE have not a clue about this, mozilla puts on incorrect extensions.
	if (is_browser('mozilla'))
	{
		$filename = "filename*=" . $filename_charset . "''" . rawurlencode($filename);
	}
	else
	{
		// other browsers seem to want names in UTF-8
		if ($filename_charset != 'utf-8' AND function_exists('iconv'))
		{
			$filename = @iconv($filename_charset, 'UTF-8//IGNORE', $filename);
		}

		// Should just make this (!is_browser('ie'))
		if (is_browser('opera') OR is_browser('konqueror') OR is_browser('safari'))
		{
			// Opera / konqueror does not support encoded file names
			$filename = 'filename="' . str_replace('"', '', $filename) . '"';
		}
		else
		{
			// encode the filename to stay within spec
			$filename = 'filename="' . rawurlencode($filename) . '"';
		}
	}

	header('Content-Type: ' . $filetype);
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Content-Disposition: attachment; ' . $filename);
	if (PHP_INT_SIZE === 8)
	{
		// Support browser progress bars on 64bit OSes
		header('Content-Length: ' . filesize($filepath));
	}
	header('Cache-Control: private, must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');

	// Make sure we can run as long as we need to
	set_time_limit(0);

	$file = @fopen($filepath, 'rb');
	while (!feof($file))
	{
		// Print the file to the buffer
		print(@fread($file, 8192));

		// Flush buffers
		ob_flush();
		flush();
	}

	if ($unlink)
	{
		// We're meant to delete the file
		@unlink($filepath);
	}

	die();
}

?>